/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.network;

import java.util.Vector;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.VerificationUtil;

public class ConMatrix {
    private static MessageBundle s_msgBundle = VerificationUtil.getMessageBundle("Prvf");
    public static final int SUCCESSFUL = 1;
    public static final int PARTIALLY_SUCCESSFUL = 2;
    public static final int FAILED = 3;
    public static final int UNKNOWN = 4;
    public static final int FAILED_PREMATURE = 5;
    private String m_key;
    private int m_status = 1;
    private boolean m_isStatusSet = false;
    private boolean m_isPatched = false;
    private String[] m_IPList = null;
    private String[] m_nodeList = null;
    private String[] m_interfaceList = null;
    private boolean[][] m_matrix;

    private ConMatrix(String key, String[] nodeList, String[] IPList, boolean[][] matrix) {
        this.m_key = key;
        this.m_nodeList = nodeList;
        this.m_IPList = IPList;
        this.m_matrix = matrix;
        for (int i = 0; i < nodeList.length; ++i) {
            for (int j = 0; j < nodeList.length; ++j) {
                this.m_matrix[i][j] = false;
            }
        }
    }

    public ConMatrix(String key, String[] nodeList) {
        this(key, nodeList, null, new boolean[nodeList.length][nodeList.length]);
        Trace.out((String)("Created ConMatrix for " + this.m_key + "nlenght" + nodeList.length));
    }

    public ConMatrix(String key, String[] nodeList, String[] IPList) {
        this(key, nodeList, IPList, new boolean[nodeList.length][nodeList.length]);
    }

    public ConMatrix(String key, String[] nodeList, String[] IPList, String[] interfaceList) {
        this(key, nodeList, IPList);
        this.m_interfaceList = interfaceList;
    }

    public void setInterfaceList(String[] interfaceList) {
        this.m_interfaceList = interfaceList;
    }

    public String[] getInterfaceList() {
        return this.m_interfaceList;
    }

    public void setInterface(int index, String inf) {
        this.m_interfaceList[index] = inf;
    }

    public String getInterface(int index) {
        return this.m_interfaceList[index];
    }

    public boolean setStatus(int status) {
        boolean changed = false;
        if (!this.m_isStatusSet) {
            if (this.m_status != status) {
                changed = true;
            }
            this.m_status = status;
            this.m_isStatusSet = true;
        }
        return changed;
    }

    public boolean setStatus(int status, boolean force) {
        boolean changed = false;
        if (!this.m_isStatusSet || force) {
            if (this.m_status != status) {
                changed = true;
            }
            this.m_isStatusSet = true;
            this.m_status = status;
        }
        return changed;
    }

    public int getStatus() {
        return this.m_status;
    }

    public String printStatus() {
        String str = null;
        switch (this.m_status) {
            case 1: {
                str = ReportUtil.SUCCESSFUL;
                break;
            }
            case 2: {
                str = ReportUtil.PARTIALLY_SUCCESSFUL;
                break;
            }
            case 3: {
                str = ReportUtil.FAILED;
                break;
            }
            case 4: {
                str = ReportUtil.UNKNOWN;
                break;
            }
            case 5: {
                str = ReportUtil.FAILED;
                break;
            }
            default: {
                str = "BAD CONMATRIX STATUS";
            }
        }
        return str;
    }

    public void setKey(String key) {
        this.m_key = key;
    }

    public String getKey() {
        return this.m_key;
    }

    public void setMatrix(boolean[][] matrix) {
        this.m_matrix = matrix;
    }

    protected void setNodeList(String[] nodeList) {
        this.m_nodeList = nodeList;
    }

    protected void setIPList(String[] IPList) {
        this.m_IPList = IPList;
        Trace.out((String)("Created ConMatrix for " + this.m_key + " nodelenght:" + this.m_nodeList.length + " IPLenght:" + this.m_IPList.length));
    }

    public String[] getNodeList() {
        return this.m_nodeList;
    }

    public String[] getUniqueNodeList() {
        Vector<String> vNodes = new Vector<String>(this.m_nodeList.length);
        for (int i = 0; i < this.m_nodeList.length; ++i) {
            if (vNodes.contains(this.m_nodeList[i])) continue;
            vNodes.addElement(this.m_nodeList[i]);
        }
        Object[] uniqueNodes = new String[vNodes.size()];
        vNodes.copyInto(uniqueNodes);
        return uniqueNodes;
    }

    public String[] getIPList() {
        return this.m_IPList;
    }

    protected void setNodeName(int index, String name) {
        this.m_nodeList[index] = name;
    }

    protected void setIP(int index, String address) {
        if (this.m_IPList != null) {
            this.m_IPList[index] = address;
        }
    }

    public String getNodeName(int index) {
        return this.m_nodeList[index];
    }

    public String getIP(int index) {
        if (this.m_IPList != null) {
            return this.m_IPList[index];
        }
        return null;
    }

    public void patchMatrix() {
        int i;
        for (i = 0; i < this.m_matrix[0].length; ++i) {
            this.m_matrix[i][0] = this.m_matrix[0][i];
        }
        for (i = 0; i < this.m_matrix[0].length; ++i) {
            for (int j = 0; j < this.m_matrix[0].length; ++j) {
                if (!this.m_matrix[0][i] || !this.m_matrix[0][j]) continue;
                this.m_matrix[j][i] = true;
                this.m_matrix[i][j] = true;
            }
        }
        this.m_isPatched = true;
    }

    public boolean[][] getMatrixForOutput() {
        if (!this.m_isStatusSet || this.m_status == 5 || this.m_status == 4) {
            Trace.out((String)("isStatusSet" + this.m_isStatusSet));
            Trace.out((String)("Status " + this.m_status));
            return null;
        }
        if (!this.m_isPatched) {
            this.patchMatrix();
        }
        return this.m_matrix;
    }

    public boolean[][] getMatrixForChange() {
        this.m_isPatched = false;
        return this.m_matrix;
    }

    public String toString() {
        StringBuffer sBuf = new StringBuffer(this.m_key + ":\n");
        if (this.m_IPList == null || this.m_nodeList == null) {
            sBuf.append("\tError\n");
            return sBuf.toString();
        }
        for (int i = 0; i < this.m_nodeList.length; ++i) {
            for (int j = 0; j < this.m_nodeList.length; ++j) {
                if (this.m_IPList[i].equals("127.0.0.1")) {
                    sBuf.append("Can't connect from loop back interface to " + this.m_IPList[j] + "\n");
                    continue;
                }
                if (this.m_matrix[i][j]) {
                    if (i == j) continue;
                    sBuf.append(this.m_nodeList[i] + ":" + this.m_IPList[i] + " ----> " + this.m_nodeList[j] + ":" + this.m_IPList[j] + "\n");
                    continue;
                }
                if (i == j) {
                    sBuf.append("Make sure ip address:" + this.m_IPList[i] + " is a valid IP address on node: " + this.m_nodeList[i] + "\n");
                    continue;
                }
                sBuf.append(this.m_nodeList[i] + ":" + this.m_IPList[i] + " -XX-> " + this.m_nodeList[j] + ":" + this.m_IPList[j] + "\n");
            }
        }
        return sBuf.toString();
    }
}

